<?php
$host = 'localhost';
$user = 'smaisinterno_user_geral'; 
$pass = 'Admin@99@SMAIS';      
$db   = 'smaisinterno_estrelinha'; 

$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) { die("Erro DB"); }
$conn->set_charset("utf8mb4");

$tipo = $_GET['tipo'] ?? 'semanal';
$vencedor = null;
$titulo = "Estrela da Semana";
$subtitulo = date('d/m/Y');
$corPrincipal = "amber"; // amber ou purple

if ($tipo === 'mensal' && isset($_GET['mes'])) {
    // --- LÓGICA MENSAL ---
    $mesAlvo = $_GET['mes']; // ex: 2024-01
    $corPrincipal = "purple";
    
    // Puxa todos do mes
    $sql = "SELECT * FROM historico_vencedores WHERE data_vitoria LIKE '$mesAlvo%'";
    $res = $conn->query($sql);
    
    $ranking = [];
    while($row = $res->fetch_assoc()) {
        if(!isset($ranking[$row['nome']])) {
            $ranking[$row['nome']] = $row;
            $ranking[$row['nome']]['votos'] = 0;
        }
        $ranking[$row['nome']]['votos'] += $row['votos'];
    }
    
    // Ordena
    usort($ranking, function($a, $b) { return $b['votos'] - $a['votos']; });
    
    if (count($ranking) > 0) {
        $vencedor = $ranking[0];
        $titulo = "Estrela do Mês";
        $partes = explode('-', $mesAlvo);
        $subtitulo = "Destaque de " . $partes[1] . '/' . $partes[0];
    }

} else {
    // --- LÓGICA SEMANAL (PADRÃO) ---
    $id = intval($_GET['id'] ?? 0);
    $res = $conn->query("SELECT * FROM historico_vencedores WHERE id = $id");
    if ($res->num_rows > 0) {
        $vencedor = $res->fetch_assoc();
        $subtitulo = date('d/m/Y', strtotime($vencedor['data_vitoria']));
    }
}

if (!$vencedor) {
    die("<h1 style='color:white; text-align:center; margin-top:50px; font-family:sans-serif'>Registro não encontrado :(</h1>");
}

// Configura cores baseadas no tipo
$corTexto = ($corPrincipal == 'purple') ? 'text-purple-400' : 'text-amber-400';
$corBorda = ($corPrincipal == 'purple') ? 'border-purple-400' : 'border-amber-400';
$corSombra = ($corPrincipal == 'purple') ? 'rgba(192, 132, 252, 0.5)' : 'rgba(251,191,36,0.5)';
$bgGradient = ($corPrincipal == 'purple') ? 'from-purple-900 to-slate-900' : 'from-slate-800 via-slate-900 to-black';
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Parabéns <?php echo htmlspecialchars($vencedor['nome']); ?>!</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://unpkg.com/lucide@latest"></script>
    <script src="https://cdn.jsdelivr.net/npm/canvas-confetti@1.6.0/dist/confetti.browser.min.js"></script>
    <style>
        @keyframes winnerPulse { 0% { transform: scale(1); box-shadow: 0 0 0 0 <?php echo $corSombra; ?>; } 70% { transform: scale(1.05); box-shadow: 0 0 0 30px rgba(0,0,0,0); } 100% { transform: scale(1); box-shadow: 0 0 0 0 rgba(0,0,0,0); } }
        .glass-card { background: rgba(30, 41, 59, 0.7); backdrop-filter: blur(10px); border: 1px solid rgba(255, 255, 255, 0.1); }
        .winner-mode-card { animation: winnerPulse 2s infinite; border-color: <?php echo ($corPrincipal=='purple'?'#c084fc':'#fbbf24'); ?>; background: linear-gradient(145deg, rgba(30, 41, 59, 0.9), rgba(0,0,0,0.2)); transform: scale(1.2); }
    </style>
</head>
<body class="bg-slate-900 text-slate-200 font-sans min-h-screen flex items-center justify-center overflow-hidden">

    <div class="fixed inset-0 pointer-events-none -z-10">
        <div class="absolute top-0 left-0 w-full h-full bg-[radial-gradient(ellipse_at_top,_var(--tw-gradient-stops))] <?php echo $bgGradient; ?>"></div>
        <div class="absolute top-0 left-1/4 w-96 h-96 bg-white/5 rounded-full blur-[120px]"></div>
    </div>

    <div class="glass-card winner-mode-card rounded-3xl p-10 flex flex-col items-center relative max-w-lg w-full mx-4">
        <div class="absolute -top-16 z-50 animate-bounce">
            <i data-lucide="crown" class="w-24 h-24 <?php echo $corTexto; ?> fill-current drop-shadow-lg"></i>
        </div>
        <div class="relative mb-6 mt-8">
                <div class="absolute inset-0 <?php echo ($corPrincipal=='purple'?'bg-purple-500':'bg-amber-500'); ?> blur-2xl opacity-60 rounded-full animate-pulse"></div>
            <img src="<?php echo htmlspecialchars($vencedor['foto']); ?>" class="w-48 h-48 rounded-full object-cover border-8 <?php echo $corBorda; ?> shadow-2xl relative z-10">
            <div class="absolute -bottom-4 left-1/2 -translate-x-1/2 <?php echo ($corPrincipal=='purple'?'bg-purple-600':'bg-amber-500'); ?> text-white font-bold px-6 py-2 rounded-full border-4 border-slate-900 shadow-xl z-20 whitespace-nowrap text-xl">
                <?php echo $vencedor['votos']; ?> Votos Totais
            </div>
        </div>
        <h2 class="text-5xl font-extrabold text-white mb-2 text-center drop-shadow-lg"><?php echo htmlspecialchars($vencedor['nome']); ?></h2>
        <p class="<?php echo $corTexto; ?> font-bold text-xl tracking-[0.2em] uppercase"><?php echo $titulo; ?></p>
        <p class="text-slate-400 text-sm mt-4 font-mono border border-slate-600 px-3 py-1 rounded-full">
            <?php echo $subtitulo; ?>
        </p>

        <a href="index.php" class="mt-8 text-xs text-slate-500 hover:text-white transition-colors">Voltar para Votação</a>
    </div>

    <script>
        lucide.createIcons();
        // Inicia confetes
        let colors = <?php echo ($corPrincipal=='purple') ? "['#a855f7', '#d8b4fe', '#ffffff']" : "['#fbbf24', '#10b981', '#ffffff']"; ?>;
        
        setInterval(function() {
            confetti({ particleCount: 5, angle: 60, spread: 55, origin: { x: 0 }, colors: colors });
            confetti({ particleCount: 5, angle: 120, spread: 55, origin: { x: 1 }, colors: colors });
        }, 200);
    </script>
</body>
</html>