<?php
$host = 'localhost';
$user = 'smaisinterno_user_geral'; 
$pass = 'Admin@99@SMAIS';      
$db   = 'smaisinterno_estrelinha'; 
$senhaAdmin = 'Admin@99@SMAIS'; 

$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) { die("Erro DB: " . $conn->connect_error); }
$conn->set_charset("utf8mb4");

// L��gica de Exclus�0�0o (Admin)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['acao']) && $_POST['acao'] === 'excluir') {
    if ($_POST['senha'] === $senhaAdmin) {
        $idExcluir = intval($_POST['id']);
        $conn->query("DELETE FROM historico_vencedores WHERE id = $idExcluir");
        header('Location: historico.php?msg=sucesso');
        exit;
    } else {
        echo "<script>alert('Senha incorreta!'); window.history.back();</script>";
        exit;
    }
}

$historico = $conn->query("SELECT * FROM historico_vencedores ORDER BY data_vitoria DESC");
$dadosHistorico = [];
while($row = $historico->fetch_assoc()) { $dadosHistorico[] = $row; }

// --- L�0�7GICA DE C�0�9LCULO MENSAL ---
$vencedoresMensais = [];
$acumuladoMes = [];

foreach ($dadosHistorico as $vitoria) {
    $mesAno = date('Y-m', strtotime($vitoria['data_vitoria'])); // Ex: 2024-01
    
    if (!isset($acumuladoMes[$mesAno])) { $acumuladoMes[$mesAno] = []; }
    
    // Soma votos por pessoa no m��s
    $nome = $vitoria['nome'];
    if (!isset($acumuladoMes[$mesAno][$nome])) {
        $acumuladoMes[$mesAno][$nome] = ['votos' => 0, 'foto' => $vitoria['foto'], 'nome' => $nome];
    }
    $acumuladoMes[$mesAno][$nome]['votos'] += $vitoria['votos'];
}

// Define o campe�0�0o de cada m��s
foreach ($acumuladoMes as $mes => $candidatos) {
    // Ordena quem teve mais votos no m��s
    usort($candidatos, function($a, $b) { return $b['votos'] - $a['votos']; });
    if (count($candidatos) > 0) {
        $campeao = $candidatos[0];
        $campeao['mes_ref'] = $mes;
        $vencedoresMensais[] = $campeao;
    }
}

// Formata data em portugu��s
setlocale(LC_TIME, 'pt_BR', 'pt_BR.utf-8', 'portuguese');
function dataMes($mesAno) {
    $objDate = DateTime::createFromFormat('Y-m', $mesAno);
    return strftime('%B de %Y', $objDate->getTimestamp());
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Galeria da Fama - SMAIS</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://unpkg.com/lucide@latest"></script>
    <style>
        .glass-card { background: rgba(30, 41, 59, 0.7); backdrop-filter: blur(10px); border: 1px solid rgba(255, 255, 255, 0.1); }
        .month-card { background: linear-gradient(135deg, rgba(88, 28, 135, 0.4), rgba(30, 41, 59, 0.8)); border: 1px solid rgba(168, 85, 247, 0.3); }
    </style>
</head>
<body class="bg-slate-900 text-slate-200 font-sans min-h-screen pb-20 overflow-x-hidden">
    <div class="fixed inset-0 pointer-events-none -z-10">
        <div class="absolute top-0 left-0 w-full h-full bg-[radial-gradient(ellipse_at_top,_var(--tw-gradient-stops))] from-slate-800 via-slate-900 to-black"></div>
        <div class="absolute top-0 left-1/4 w-96 h-96 bg-emerald-600/10 rounded-full blur-[120px]"></div>
    </div>

    <header class="sticky top-0 z-40 border-b border-white/5 bg-slate-900/80 backdrop-blur-md">
        <div class="max-w-7xl mx-auto px-4 py-4 flex justify-between items-center">
            <div class="flex items-center gap-3">
                <a href="index.php" class="text-slate-400 hover:text-white flex items-center gap-1 text-sm">
                    <i data-lucide="arrow-left" class="w-4 h-4"></i> Voltar
                </a>
            </div>
            <h1 class="text-xl font-bold text-white tracking-tight">Galeria <span class="text-amber-400">SMAIS</span></h1>
            <div class="w-16"></div> </div>
    </header>

    <main class="max-w-7xl mx-auto px-4 py-10">
        
        <?php if (count($vencedoresMensais) > 0): ?>
            <div class="mb-16">
                <div class="text-center mb-8">
                    <h2 class="text-3xl md:text-4xl font-extrabold text-transparent bg-clip-text bg-gradient-to-r from-purple-400 to-pink-400 mb-2">
                         Super Estrelas do M
                    </h2>
                    <p class="text-slate-400">Aqueles que mantiveram a constância e brilharam o mês todo.</p>
                </div>
                
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                    <?php foreach($vencedoresMensais as $top): ?>
                        <div class="month-card rounded-2xl p-8 flex flex-col items-center relative group transform hover:scale-105 transition-all duration-300 shadow-[0_0_30px_rgba(168,85,247,0.2)]">
                            <div class="absolute -top-4 bg-purple-600 text-white text-xs font-bold px-4 py-1 rounded-full shadow-lg uppercase tracking-widest">
                                Mês de <?php echo explode('-', $top['mes_ref'])[1] . '/' . explode('-', $top['mes_ref'])[0]; ?>
                            </div>

                            <div class="relative mb-6 mt-4">
                                <div class="absolute inset-0 bg-purple-500 blur-xl opacity-40 rounded-full animate-pulse"></div>
                                <img src="<?php echo htmlspecialchars($top['foto']); ?>" class="w-28 h-28 rounded-full object-cover border-4 border-purple-400 shadow-2xl relative z-10">
                                <div class="absolute -bottom-2 -right-2 bg-purple-900 text-white text-xs font-bold px-3 py-1 rounded-full border border-purple-500 shadow-lg z-20">
                                    TOP 1
                                </div>
                            </div>
                            
                            <h3 class="text-2xl font-bold text-white mb-2"><?php echo htmlspecialchars($top['nome']); ?></h3>
                            <p class="text-sm text-purple-300 font-bold mb-6"><?php echo $top['votos']; ?> Votos Totais no Mês</p>

                            <a href="celebracao.php?tipo=mensal&mes=<?php echo $top['mes_ref']; ?>" target="_blank" class="w-full bg-gradient-to-r from-purple-600 to-pink-600 hover:from-purple-500 hover:to-pink-500 text-white py-3 rounded-xl font-bold flex items-center justify-center gap-2 shadow-lg transition-all">
                                <i data-lucide="party-popper" class="w-4 h-4"></i> Celebração ensal
                            </a>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
            
            <div class="border-b border-slate-700 mb-12"></div>
        <?php endif; ?>

        <div class="text-center mb-12">
            <h2 class="text-2xl font-bold text-slate-300 mb-2">Histórico Semanal </h2>
            <p class="text-slate-500 text-sm">Registro de todas as vitórias individuais.</p>
        </div>

        <?php if (count($dadosHistorico) === 0): ?>
            <div class="text-center text-slate-500 py-20">
                <i data-lucide="ghost" class="w-12 h-12 mx-auto mb-4 opacity-50"></i>
                <p>Nenhum registro no histórico ainda.</p>
            </div>
        <?php else: ?>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                <?php foreach($dadosHistorico as $row): ?>
                    <div class="glass-card rounded-2xl p-6 flex flex-col items-center relative group">
                        <div class="absolute top-4 right-4 text-xs font-mono text-slate-500 border border-slate-700 px-2 py-1 rounded">
                            <?php echo date('d/m/Y', strtotime($row['data_vitoria'])); ?>
                        </div>

                        <div class="relative mb-4 mt-2">
                            <div class="absolute inset-0 bg-amber-500 blur-lg opacity-20 rounded-full"></div>
                            <img src="<?php echo htmlspecialchars($row['foto']); ?>" class="w-20 h-20 rounded-full object-cover border-2 border-amber-400 shadow-lg relative z-10">
                        </div>
                        
                        <h3 class="text-lg font-bold text-white mb-1"><?php echo htmlspecialchars($row['nome']); ?></h3>
                        <p class="text-xs text-amber-400 uppercase tracking-wider font-bold mb-4"><?php echo $row['votos']; ?> Votos</p>

                        <div class="w-full flex gap-2 mt-auto">
                            <a href="celebracao.php?id=<?php echo $row['id']; ?>" target="_blank" class="flex-1 bg-emerald-600/20 hover:bg-emerald-600/40 text-emerald-400 border border-emerald-500/30 py-2 rounded-lg text-sm font-bold flex items-center justify-center gap-2 transition-colors">
                                <i data-lucide="external-link" class="w-4 h-4"></i> Ver 
                            </a>
                            
                            <button onclick="document.getElementById('del-<?php echo $row['id']; ?>').classList.toggle('hidden')" class="bg-red-500/10 hover:bg-red-500/20 text-red-400 border border-red-500/30 p-2 rounded-lg transition-colors">
                                <i data-lucide="trash-2" class="w-4 h-4"></i>
                            </button>
                        </div>

                        <div id="del-<?php echo $row['id']; ?>" class="hidden absolute inset-0 bg-slate-900/95 backdrop-blur rounded-2xl z-20 flex flex-col items-center justify-center p-4 text-center">
                            <p class="text-red-400 font-bold mb-2">Excluir Registro?</p>
                            <form method="POST" class="w-full">
                                <input type="hidden" name="acao" value="excluir">
                                <input type="hidden" name="id" value="<?php echo $row['id']; ?>">
                                <input type="password" name="senha" placeholder="Senha Admin" class="bg-slate-800 border border-slate-600 rounded px-2 py-1 text-sm text-white w-full mb-2" required>
                                <div class="flex gap-2 justify-center w-full">
                                    <button type="button" onclick="document.getElementById('del-<?php echo $row['id']; ?>').classList.add('hidden')" class="text-xs text-slate-400 px-3 py-1">Cancelar</button>
                                    <button type="submit" class="bg-red-600 text-white text-xs font-bold px-3 py-1 rounded hover:bg-red-500">Confirmar</button>
                                </div>
                            </form>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </main>

    <script>lucide.createIcons();</script>
</body>
</html>