<?php
// --- CONFIGURAÇÃO ---
$host = 'localhost';
$user = 'smaisinterno_user_geral'; 
$pass = 'Admin@99@SMAIS';      
$db   = 'smaisinterno_estrelinha'; 
$senhaAdmin = 'Admin@99@SMAIS'; 

$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) { die("Erro DB: " . $conn->connect_error); }
$conn->set_charset("utf8mb4");

// --- SISTEMA DE TOKEN (SUBSTITUI IP) ---
if (!isset($_COOKIE['smais_token_voto'])) {
    // Gera um token único e salva por 1 ano
    $token = bin2hex(random_bytes(16));
    setcookie('smais_token_voto', $token, time() + (86400 * 365), "/");
    $_COOKIE['smais_token_voto'] = $token;
}
$usuarioToken = $_COOKIE['smais_token_voto'];

// Helper para pegar status
function getStatusVotacao($conn) {
    $res = $conn->query("SELECT valor FROM config WHERE chave = 'status_votacao'");
    if ($res && $res->num_rows > 0) return $res->fetch_assoc()['valor'];
    return 'aberta';
}

// --- API BACKEND (JSON) ---

// 1. Votar
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['acao']) && $_POST['acao'] === 'votar') {
    header('Content-Type: application/json');
    
    if (getStatusVotacao($conn) === 'finalizada') {
        echo json_encode(['sucesso' => false, 'msg' => 'A votação foi encerrada! Aguarde o resultado.']);
        exit;
    }

    $id = intval($_POST['id']);
    // Verifica pelo TOKEN e não pelo IP
    $tokenAtual = $_COOKIE['smais_token_voto'] ?? '';

    if (empty($tokenAtual)) {
        echo json_encode(['sucesso' => false, 'msg' => 'Erro de identificação. Atualize a página.']);
        exit;
    }

    $check = $conn->prepare("SELECT id FROM logs_votos WHERE token_usuario = ?");
    $check->bind_param("s", $tokenAtual);
    $check->execute();
    $resCheck = $check->get_result();

    if ($resCheck->num_rows > 0) {
        echo json_encode(['sucesso' => false, 'msg' => 'Você já votou nesta rodada!']);
        exit;
    }

    $conn->query("UPDATE candidatos SET votos = votos + 1 WHERE id = $id");
    
    $stmt = $conn->prepare("INSERT INTO logs_votos (token_usuario, candidato_escolhido) VALUES (?, ?)");
    $stmt->bind_param("si", $tokenAtual, $id);
    $stmt->execute();
    
    // Cookie visual apenas para feedback rápido no front
    setcookie("smais_votou_visual", "true", time() + (86400 * 7), "/"); 

    echo json_encode(['sucesso' => true]);
    exit;
}

// 2. Enviar Reação (Emoji)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['acao']) && $_POST['acao'] === 'reagir') {
    header('Content-Type: application/json');
    $emoji = $conn->real_escape_string($_POST['emoji']);
    
    if(rand(1, 20) == 1) { 
        $conn->query("DELETE FROM reacoes WHERE created_at < NOW() - INTERVAL 5 MINUTE"); 
    }
    
    $conn->query("INSERT INTO reacoes (emoji) VALUES ('$emoji')");
    echo json_encode(['sucesso' => true]);
    exit;
}

// 3. Atualização em Tempo Real
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['api']) && $_GET['api'] === 'status') {
    header('Content-Type: application/json');
    
    $res = $conn->query("SELECT id, nome, foto, votos FROM candidatos ORDER BY votos DESC, nome ASC");
    $candidatos = [];
    while($row = $res->fetch_assoc()) { $candidatos[] = $row; }

    $lastId = intval($_GET['last_reaction_id'] ?? 0);
    $resReac = $conn->query("SELECT id, emoji FROM reacoes WHERE id > $lastId ORDER BY id ASC");
    
    $novasReacoes = [];
    $maxId = $lastId;
    while($row = $resReac->fetch_assoc()) { 
        $novasReacoes[] = $row['emoji']; 
        $maxId = max($maxId, $row['id']);
    }

    echo json_encode([
        'status_votacao' => getStatusVotacao($conn),
        'candidatos' => $candidatos,
        'last_reaction_id' => $maxId,
        'novas_reacoes' => $novasReacoes
    ]);
    exit;
}

// 4. Admin Actions
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['acao']) && $_POST['acao'] === 'admin') {
    if ($_POST['senha'] !== $senhaAdmin) { header('Location: index.php?erro=senha'); exit; }

    if ($_POST['tipo'] === 'adicionar') {
        $nome = $conn->real_escape_string($_POST['nome']);
        $foto = $_POST['foto'] ?: "https://ui-avatars.com/api/?name=".urlencode($nome)."&background=10b981&color=fff";
        $conn->query("INSERT INTO candidatos (nome, foto) VALUES ('$nome', '$foto')");
    
    } elseif ($_POST['tipo'] === 'finalizar') {
        $resVencedor = $conn->query("SELECT nome, foto, votos FROM candidatos ORDER BY votos DESC LIMIT 1");
        if ($resVencedor && $resVencedor->num_rows > 0) {
            $vencedor = $resVencedor->fetch_assoc();
            if ($vencedor['votos'] > 0) {
                $stmtH = $conn->prepare("INSERT INTO historico_vencedores (nome, foto, votos, data_vitoria) VALUES (?, ?, ?, NOW())");
                $stmtH->bind_param("ssi", $vencedor['nome'], $vencedor['foto'], $vencedor['votos']);
                $stmtH->execute();
            }
        }
        $conn->query("UPDATE config SET valor = 'finalizada' WHERE chave = 'status_votacao'");
    
    } elseif ($_POST['tipo'] === 'resetar') {
        $conn->query("UPDATE candidatos SET votos = 0");
        $conn->query("TRUNCATE TABLE logs_votos"); // Limpa logs, permitindo que tokens votem de novo
        $conn->query("TRUNCATE TABLE reacoes");
        $conn->query("UPDATE config SET valor = 'aberta' WHERE chave = 'status_votacao'");
        setcookie("smais_votou_visual", "", time() - 3600, "/"); // Limpa cookie visual
    }
    
    header('Location: index.php?admin=true');
    exit;
}

// --- DADOS INICIAIS ---
// Verificação de voto via Token no Banco
$checkVoto = $conn->prepare("SELECT id FROM logs_votos WHERE token_usuario = ?");
$checkVoto->bind_param("s", $usuarioToken);
$checkVoto->execute();
$resCheckVoto = $checkVoto->get_result();
$jaVotou = ($resCheckVoto->num_rows > 0);

$resMaxEmoji = $conn->query("SELECT MAX(id) as max_id FROM reacoes");
$rowMaxEmoji = $resMaxEmoji->fetch_assoc();
$ultimoIdInicial = intval($rowMaxEmoji['max_id'] ?? 0);

?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Estrela da Semana - SMAIS Digital</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://unpkg.com/lucide@latest"></script>
    <script src="https://cdn.jsdelivr.net/npm/canvas-confetti@1.6.0/dist/confetti.browser.min.js"></script>
    <style>
        @keyframes floatUp { 0% { transform: translateY(0) scale(1); opacity: 1; } 100% { transform: translateY(-100vh) scale(1.5); opacity: 0; } }
        @keyframes winnerPulse { 0% { transform: scale(1); box-shadow: 0 0 0 0 rgba(251, 191, 36, 0.7); } 70% { transform: scale(1.05); box-shadow: 0 0 0 30px rgba(251, 191, 36, 0); } 100% { transform: scale(1); box-shadow: 0 0 0 0 rgba(251, 191, 36, 0); } }
        .emoji-float { position: fixed; bottom: -50px; font-size: 2rem; pointer-events: none; z-index: 50; animation: floatUp 3s linear forwards; }
        .glass-card { background: rgba(30, 41, 59, 0.7); backdrop-filter: blur(10px); border: 1px solid rgba(255, 255, 255, 0.1); }
        .leader-glow { box-shadow: 0 0 30px rgba(251, 191, 36, 0.3); border-color: #fbbf24; transform: scale(1.05); }
        .winner-mode-card { animation: winnerPulse 2s infinite; border-color: #fbbf24; background: linear-gradient(145deg, rgba(30, 41, 59, 0.9), rgba(251, 191, 36, 0.1)); transform: scale(1.2); }
        #grid-candidatos { display: grid; grid-template-columns: repeat(1, 1fr); gap: 1.5rem; transition: opacity 0.5s ease; }
        @media (min-width: 640px) { #grid-candidatos { grid-template-columns: repeat(2, 1fr); } }
        @media (min-width: 1024px) { #grid-candidatos { grid-template-columns: repeat(3, 1fr); } }
        @media (min-width: 1280px) { #grid-candidatos { grid-template-columns: repeat(4, 1fr); } }
        #winner-container { display: none; opacity: 0; transition: opacity 1s ease-in-out; }
        .show-winner { display: flex !important; opacity: 1 !important; }
    </style>
</head>
<body class="bg-slate-900 text-slate-200 font-sans min-h-screen pb-20 overflow-x-hidden">
    <div class="fixed inset-0 pointer-events-none -z-10">
        <div class="absolute top-0 left-0 w-full h-full bg-[radial-gradient(ellipse_at_top,_var(--tw-gradient-stops))] from-slate-800 via-slate-900 to-black"></div>
        <div class="absolute top-0 left-1/4 w-96 h-96 bg-emerald-600/10 rounded-full blur-[120px]"></div>
        <div class="absolute bottom-0 right-1/4 w-96 h-96 bg-blue-600/10 rounded-full blur-[120px]"></div>
    </div>

    <header class="sticky top-0 z-40 border-b border-white/5 bg-slate-900/80 backdrop-blur-md">
        <div class="max-w-7xl mx-auto px-4 py-4 flex justify-between items-center">
            <div class="flex items-center gap-3">
                <div class="relative group">
                    <div class="absolute -inset-1 bg-gradient-to-r from-emerald-600 to-teal-600 rounded-lg blur opacity-40 group-hover:opacity-75 transition duration-200"></div>
                    <div class="relative w-10 h-10 bg-slate-900 rounded-lg flex items-center justify-center border border-white/10">
                        <i data-lucide="star" class="text-emerald-400 w-5 h-5 fill-current"></i>
                    </div>
                </div>
                <div>
                    <h1 class="text-xl font-bold text-white tracking-tight">SMAIS <span class="text-emerald-400">Destaque</span></h1>
                </div>
            </div>
            <div class="flex items-center gap-2">
                <a href="historico.php" class="text-xs text-amber-400 hover:text-amber-300 transition-colors flex items-center gap-1 bg-amber-500/10 px-3 py-1.5 rounded-full border border-amber-500/20 font-bold">
                    <i data-lucide="trophy" class="w-3 h-3"></i> Galeria
                </a>
                <button onclick="toggleAdmin()" class="text-xs text-slate-500 hover:text-white transition-colors flex items-center gap-1 bg-white/5 px-3 py-1.5 rounded-full border border-white/5">
                    <i data-lucide="lock" class="w-3 h-3"></i> Admin
                </button>
            </div>
        </div>
    </header>

    <main class="max-w-7xl mx-auto px-4 py-8 relative">
        <div class="fixed bottom-6 right-6 z-50 flex flex-col gap-2 items-end">
            <div class="bg-slate-800/90 backdrop-blur border border-white/10 p-2 rounded-2xl shadow-2xl flex gap-2">
                <button onclick="enviarReacao('🔥')" class="hover:scale-125 transition text-2xl p-1 active:scale-95">🔥</button>
                <button onclick="enviarReacao('👏')" class="hover:scale-125 transition text-2xl p-1 active:scale-95">👏</button>
                <button onclick="enviarReacao('🚀')" class="hover:scale-125 transition text-2xl p-1 active:scale-95">🚀</button>
                <button onclick="enviarReacao('❤️')" class="hover:scale-125 transition text-2xl p-1 active:scale-95">❤️</button>
            </div>
            <p class="text-[10px] text-slate-500 bg-slate-900/80 px-2 rounded">Clique para reagir ao vivo!</p>
        </div>

        <div class="text-center mb-10 space-y-3 relative" id="header-text">
            <h2 id="titulo-principal" class="text-3xl md:text-5xl font-extrabold text-transparent bg-clip-text bg-gradient-to-r from-white via-slate-200 to-slate-400">
                Quem brilhou na semana?
            </h2>
            <p id="subtitulo-principal" class="text-slate-400 max-w-xl mx-auto text-lg leading-relaxed">
                Votação em tempo real. Escolha quem fez a diferença!
            </p>
            
            <div id="statusVotoUsuario" class="mt-4">
                <?php if ($jaVotou): ?>
                    <span class="inline-flex items-center gap-2 px-4 py-2 rounded-full bg-emerald-500/10 text-emerald-400 border border-emerald-500/20 text-sm font-bold">
                        <i data-lucide="check-circle" class="w-4 h-4"></i> Voto Confirmado
                    </span>
                <?php else: ?>
                    <span class="inline-flex items-center gap-2 px-4 py-2 rounded-full bg-amber-500/10 text-amber-400 border border-amber-500/20 text-sm font-bold animate-pulse">
                        <i data-lucide="clock" class="w-4 h-4"></i> Aguardando seu voto
                    </span>
                <?php endif; ?>
            </div>
        </div>

        <div id="adminPanel" class="hidden mb-12 glass-card p-6 rounded-2xl shadow-2xl">
            <div class="flex justify-between items-center mb-6">
                <h3 class="text-emerald-400 font-bold text-lg flex items-center gap-2">
                    <i data-lucide="settings" class="w-5 h-5"></i> Área Administrativa
                </h3>
                <button onclick="toggleAdmin()" class="text-slate-400 hover:text-white"><i data-lucide="x" class="w-5 h-5"></i></button>
            </div>
            
            <div class="grid md:grid-cols-3 gap-6">
                <form action="index.php" method="POST" class="space-y-4 md:col-span-1">
                    <input type="hidden" name="acao" value="admin">
                    <input type="hidden" name="tipo" value="adicionar">
                    <p class="text-white text-sm font-bold mb-2">Adicionar Novo</p>
                    <input type="password" name="senha" placeholder="Senha" class="bg-slate-950 border border-slate-700 rounded-lg px-3 py-2 text-white w-full text-sm mb-2" required>
                    <input type="text" name="nome" placeholder="Nome" class="bg-slate-950 border border-slate-700 rounded-lg px-3 py-2 text-white w-full text-sm mb-2" required>
                    <button type="submit" class="w-full bg-emerald-600 hover:bg-emerald-500 text-white font-bold py-2 rounded-lg text-sm">Adicionar</button>
                </form>

                <form action="index.php" method="POST" class="space-y-4 md:col-span-1" onsubmit="return confirm('ATENÇÃO: Isso encerrará a votação e SALVARÁ O VENCEDOR NA GALERIA. Confirmar?');">
                    <input type="hidden" name="acao" value="admin">
                    <input type="hidden" name="tipo" value="finalizar">
                    <div class="bg-amber-500/10 border border-amber-500/20 p-4 rounded-lg h-full flex flex-col justify-between">
                        <div>
                            <p class="text-amber-400 text-sm font-bold mb-1"><i data-lucide="trophy" class="inline w-4 h-4 mr-1"></i> Revelar e Salvar</p>
                            <p class="text-xs text-slate-400 mb-3">Trava votos, mostra campeão e salva no histórico.</p>
                        </div>
                        <input type="password" name="senha" placeholder="Senha" class="bg-slate-950 border border-amber-900/50 rounded-lg px-3 py-2 text-white w-full text-sm mb-2" required>
                        <button type="submit" class="w-full bg-amber-600 hover:bg-amber-500 text-white font-bold py-2 rounded-lg text-sm">
                            Finalizar Votação
                        </button>
                    </div>
                </form>

                <form action="index.php" method="POST" class="space-y-4 md:col-span-1" onsubmit="return confirm('ZERAR TUDO? Isso apaga os votos atuais para começar uma nova semana (o histórico permanece).');">
                    <input type="hidden" name="acao" value="admin">
                    <input type="hidden" name="tipo" value="resetar">
                    <div class="bg-red-500/5 border border-red-500/20 p-4 rounded-lg h-full flex flex-col justify-between">
                        <div>
                            <p class="text-red-400 text-sm font-bold mb-1"><i data-lucide="trash-2" class="inline w-4 h-4 mr-1"></i> Nova Rodada</p>
                            <p class="text-xs text-slate-400 mb-3">Zera votos e reabre para nova semana.</p>
                        </div>
                        <input type="password" name="senha" placeholder="Senha" class="bg-slate-950 border border-red-900/50 rounded-lg px-3 py-2 text-white w-full text-sm mb-2" required>
                        <button type="submit" class="w-full bg-red-600 hover:bg-red-500 text-white font-bold py-2 rounded-lg text-sm">
                            Zerar Sistema
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <div id="winner-container" class="flex flex-col items-center justify-center min-h-[50vh] relative z-20"></div>

        <div id="grid-candidatos">
            <div class="col-span-full text-center py-20">
                <i data-lucide="loader-2" class="w-10 h-10 animate-spin text-emerald-500 mx-auto"></i>
                <p class="text-slate-500 mt-4">Carregando...</p>
            </div>
        </div>
    </main>

    <template id="card-template">
        <div class="card-candidato glass-card rounded-2xl p-6 relative group hover:bg-slate-800/80">
            <div class="crown-container hidden absolute -top-6 left-1/2 -translate-x-1/2 z-30 transition-all duration-500">
                <i data-lucide="crown" class="w-12 h-12 text-amber-400 fill-amber-400 drop-shadow-[0_0_15px_rgba(251,191,36,0.6)] animate-bounce"></i>
            </div>
            <div class="flex flex-col items-center relative z-10">
                <div class="relative mb-4 mt-2">
                    <div class="glow-bg absolute inset-0 bg-emerald-500 blur-xl opacity-0 transition-opacity duration-500 rounded-full"></div>
                    <img src="" class="img-candidato w-24 h-24 rounded-full object-cover border-4 border-slate-700 bg-slate-800 shadow-xl relative z-10">
                    <div class="votos-badge absolute -bottom-2 -right-2 bg-slate-900 text-white text-xs font-bold px-2.5 py-1 rounded-full border border-slate-700 shadow-lg z-20 min-w-[30px] text-center">0</div>
                </div>
                <h3 class="nome-candidato text-xl font-bold text-white mb-1 text-center truncate w-full">Nome</h3>
                <p class="status-text text-xs text-slate-500 font-medium mb-6 uppercase tracking-wider">Time SMAIS</p>
                <button class="btn-votar w-full py-3 rounded-xl font-bold flex items-center justify-center gap-2 transition-all duration-200 bg-slate-700 hover:bg-emerald-600 text-white shadow-lg active:scale-95">
                    <span class="btn-label">Votar</span>
                </button>
            </div>
        </div>
    </template>

    <script>
        let jaVotou = <?php echo $jaVotou ? 'true' : 'false'; ?>;
        let lastReactionId = <?php echo $ultimoIdInicial; ?>; 
        let confettiInterval = null;
        let isFinalizado = false;

        lucide.createIcons();
        setInterval(atualizarDados, 1000); 
        atualizarDados();

        async function atualizarDados() {
            try {
                const response = await fetch(`index.php?api=status&last_reaction_id=${lastReactionId}`);
                const data = await response.json();
                if (!data.candidatos) return;

                if (data.status_votacao === 'finalizada') {
                    if (!isFinalizado) ativarModoVencedor(data.candidatos[0]);
                } else {
                    if (isFinalizado) desativarModoVencedor();
                    renderizarCandidatos(data.candidatos);
                }
                processarReacoes(data.novas_reacoes, data.last_reaction_id);
            } catch (e) { console.error("Erro live", e); }
        }

        function renderizarCandidatos(lista) {
            const grid = document.getElementById('grid-candidatos');
            grid.innerHTML = ''; 

            lista.forEach((c, index) => {
                const isLeader = (index === 0 && parseInt(c.votos) > 0);
                const template = document.getElementById('card-template').content;
                const clone = document.importNode(template, true);
                
                const cardDiv = clone.querySelector('.card-candidato');
                const img = clone.querySelector('.img-candidato');
                
                img.src = c.foto;
                clone.querySelector('.nome-candidato').textContent = c.nome;
                clone.querySelector('.votos-badge').textContent = c.votos;

                if (isLeader) {
                    cardDiv.classList.add('leader-glow', 'z-10');
                    clone.querySelector('.crown-container').classList.remove('hidden');
                    clone.querySelector('.status-text').textContent = '👑 Destaque Atual';
                    clone.querySelector('.status-text').classList.add('text-amber-400', 'font-bold');
                    img.classList.remove('border-slate-700');
                    img.classList.add('border-amber-400');
                    clone.querySelector('.glow-bg').classList.add('opacity-40');
                }

                const btn = clone.querySelector('.btn-votar');
                if (jaVotou) {
                    btn.disabled = true;
                    btn.classList.add('opacity-50', 'cursor-not-allowed', 'bg-slate-800');
                    btn.innerHTML = '<i data-lucide="lock" class="w-4 h-4"></i> Registrado';
                } else {
                    btn.onclick = () => confirmarVoto(c.id);
                    btn.innerHTML = isLeader ? '<i data-lucide="star" class="w-4 h-4 fill-current"></i> Votar no Líder' : '<i data-lucide="star" class="w-4 h-4"></i> Votar';
                    if (isLeader) btn.classList.replace('bg-slate-700', 'bg-amber-500');
                }
                grid.appendChild(clone);
            });
            lucide.createIcons();
        }

        function ativarModoVencedor(vencedor) {
            isFinalizado = true;
            document.getElementById('grid-candidatos').style.display = 'none';
            document.getElementById('statusVotoUsuario').style.display = 'none';
            document.getElementById('titulo-principal').innerText = "🎉 TEMOS UM DESTAQUE! 🎉";
            document.getElementById('subtitulo-principal').innerText = "A votação foi encerrada. Parabéns pelo desempenho incrível!";

            const container = document.getElementById('winner-container');
            container.innerHTML = `
                <div class="glass-card winner-mode-card rounded-3xl p-10 flex flex-col items-center relative max-w-lg w-full">
                    <div class="absolute -top-16 z-50 animate-bounce">
                        <i data-lucide="crown" class="w-24 h-24 text-amber-400 fill-amber-400 drop-shadow-[0_0_25px_rgba(251,191,36,0.8)]"></i>
                    </div>
                    <div class="relative mb-6 mt-8">
                         <div class="absolute inset-0 bg-amber-500 blur-2xl opacity-60 rounded-full animate-pulse"></div>
                        <img src="${vencedor.foto}" class="w-48 h-48 rounded-full object-cover border-8 border-amber-400 shadow-[0_0_50px_rgba(251,191,36,0.5)] relative z-10">
                        <div class="absolute -bottom-4 left-1/2 -translate-x-1/2 bg-amber-500 text-slate-900 font-bold px-6 py-2 rounded-full border-4 border-slate-900 shadow-xl z-20 whitespace-nowrap text-xl">
                            ${vencedor.votos} Votos
                        </div>
                    </div>
                    <h2 class="text-5xl font-extrabold text-white mb-2 text-center drop-shadow-lg">${vencedor.nome}</h2>
                    <p class="text-amber-400 font-bold text-xl tracking-[0.2em] uppercase">Campeão da Semana</p>
                </div>
            `;
            container.classList.add('show-winner');
            lucide.createIcons();
            iniciarChuvaConfetes();
        }

        function desativarModoVencedor() {
            isFinalizado = false;
            document.getElementById('grid-candidatos').style.display = 'grid'; 
            document.getElementById('statusVotoUsuario').style.display = 'block';
            document.getElementById('winner-container').classList.remove('show-winner');
            document.getElementById('winner-container').innerHTML = '';
            document.getElementById('titulo-principal').innerText = "Quem brilhou na semana?";
            document.getElementById('subtitulo-principal').innerText = "Votação em tempo real. Escolha quem fez a diferença!";
            pararChuvaConfetes();
            location.reload(); 
        }

        function iniciarChuvaConfetes() {
            if (confettiInterval) return;
            confettiInterval = setInterval(function() {
                confetti({ particleCount: 5, angle: 60, spread: 55, origin: { x: 0 }, colors: ['#fbbf24', '#10b981', '#ffffff'] });
                confetti({ particleCount: 5, angle: 120, spread: 55, origin: { x: 1 }, colors: ['#fbbf24', '#10b981', '#ffffff'] });
            }, 200);
        }

        function pararChuvaConfetes() {
            clearInterval(confettiInterval);
            confettiInterval = null;
        }

        async function confirmarVoto(id) {
            const btns = document.querySelectorAll('.btn-votar');
            btns.forEach(b => { b.disabled = true; b.innerHTML = '...'; });

            const fd = new FormData();
            fd.append('acao', 'votar');
            fd.append('id', id);

            const res = await fetch('index.php', { method:'POST', body: fd });
            const json = await res.json();

            if (json.sucesso) {
                jaVotou = true;
                confetti({ particleCount: 100, spread: 70, origin: { y: 0.6 } });
                atualizarDados();
            } else {
                alert(json.msg);
                location.reload();
            }
        }

        async function enviarReacao(emoji) {
            criarEmojiFlutuante(emoji);
            const fd = new FormData();
            fd.append('acao', 'reagir');
            fd.append('emoji', emoji);
            fetch('index.php', { method:'POST', body: fd });
        }

        function processarReacoes(reacoes, novoLastId) {
            if (novoLastId > lastReactionId) {
                lastReactionId = novoLastId;
                reacoes.forEach((emoji, i) => {
                    setTimeout(() => criarEmojiFlutuante(emoji), i * 150);
                });
            }
        }

        function criarEmojiFlutuante(emoji) {
            const el = document.createElement('div');
            el.innerText = emoji;
            el.classList.add('emoji-float');
            el.style.left = Math.random() * 80 + 10 + '%';
            el.style.fontSize = (Math.random() * 2 + 1) + 'rem';
            document.body.appendChild(el);
            setTimeout(() => el.remove(), 3000);
        }

        function toggleAdmin() {
            document.getElementById('adminPanel').classList.toggle('hidden');
        }
    </script>
</body>
</html>